package AGC::Core;

require	Exporter;
@ISA = qw(Exporter);
@EXPORT_OK = qw(MagazineJSNodes CCCJSNodes ProjectileJSNodes ResearchJSNodes ResearchRootTree);

use strict;
use AGC::Init;

use vars qw(%nested @magazine_types @root_tree);
use vars qw($conjs $garjs $supjs $tacjs $expjs $syjs $uknjs);

@magazine_types = ('Counter',undef,'Missile','Pack','Shield','Cloak',undef,'Afterburner');
@root_tree = ('Construction','Garrison','Supremecy','Tactical','Expansion','Shipyard');

sub FindPart {
	my $uid = shift;
	my %Parts = %{$IGC{Part}};
	
	foreach my $type (keys %Parts) {
		next if $type =~ /Default/i;
		my $Items = $Parts{$type};
		foreach my $item (keys %{$Items}) {
			next if $item =~ /Default/i;
			if ($Items->{$item}{uid} == $uid) {
				return $Items->{$item};
			}
		}
	}

}

sub FindItem {
	my $uid = shift;

	foreach my $subkey (keys %IGC) {
		next if $subkey =~ /Part|Global|TreasureSet|Faction|Drone|Projectile|Ship|CORENAME|Station/i;
		my $Items = $IGC{$subkey};
		foreach my $item (keys %{$Items}) {
			next if $item =~ /Default/i;
			if ($Items->{$item}{uid} == $uid) {
				return $Items->{$item};
			}
		}
	}

}

#"
#"

sub ProjectileJSNodes {
	my $pid = shift;
	my %Weapons = %{$IGC{Part}{Weapon}};
	my %Probes = %{$IGC{Probe}};
	my $js = '';
	
	$js .= qq{
	Projectile.addItem("Weapons");
	var Weapons = null;
	Weapons = new MTMenu();
	} if (!$nested{weps});


	foreach my $wepkey (keys %Weapons) {
		if ($Weapons{$wepkey}{wep_projectile_uid} == $pid) {
			my $value = $Weapons{$wepkey}{name};
			next if $value =~ /Default/i;
			next if $value eq '';
			$js .= qq{Weapons.addItem("$value", "/AGC?IGC=$corename&P=Projectile&ID=$pid");};
		}
	}
	$js .= qq{Projectile.makeLastSubmenu(Weapons);}  if (!$nested{weps});
	$nested{weps} = 1;

	$js .= qq{
	Projectile.addItem("Probes");
	var Probes = null;
	Probes = new MTMenu();
	} if (!$nested{pros});

	foreach my $prokey (keys %Probes) {
		if ($Probes{$prokey}{projectile} == $pid) {
			my $value = $Probes{$prokey}{name};
			next if $value =~ /Default/i;
			next if $value eq '';
			$js .= qq{Probes.addItem("$value", "/AGC?IGC=$corename&P=Projectile&ID=$pid");};
		}
			
	}
	$js .= qq{Projectile.makeLastSubmenu(Probes);} if (!$nested{pros});
	$nested{pros} = 1;
	
	return $js;

}

#"
#"

sub MagazineJSNodes {
	my ($pid,$maskid,$type) = @_;
	my %Missiles = %{$IGC{Missile}};
	my $js = '';
	
	if ($type == 2) {
		$js .= qq{
		Magazine.addItem("Missile");
		var MagMissile = null;
		MagMissile = new MTMenu();
		} if (!$nested{mags});

		foreach my $miskey (keys %Missiles) {
			if ($Missiles{$miskey}{uid} == $maskid) {
				my $value = $Missiles{$miskey}{name};
				$js .= qq{MagMissile.addItem("$value", "/AGC?IGC=$corename&P=Magazine&ID=$pid");};
				last;
			}
		}

		$js .= qq{Magazine.makeLastSubmenu(MagMissile);}  if (!$nested{mags});
		$nested{mags} = 1;
	}
	
	return $js;
}

#"
#"

sub CCCJSNodes {
	my ($pid,$name) = @_;
	my %TreasureSet = %{$IGC{TreasureSet}};
	my $js = '';

	$js .= qq{
		TreasureSet.addItem("$name");
		var CCC_$pid = null;
		CCC_$pid = new MTMenu();
	};

	foreach my $treasure (keys %TreasureSet) {
		if ($TreasureSet{$treasure}{uid} == $pid) {
			my %Chances = %{$TreasureSet{$treasure}};
			foreach my $chance (keys %Chances) {
				next if $chance !~ /CHANCE/i;
				my $title = '';
				my $value = $Chances{$chance}{chance_uid};
				my $code = $Chances{$chance}{code};
				if ($code == 1) {
					my $Part = &FindPart($value);
					$title = $Part->{name};
					if (!$title) {
						my $Item = &FindItem($value);
						$title = ($Item) ? $Item->{name} : undef;
						if (!$title) {
							$title = "wtf";
						}
					}
				} elsif ($code == 2) {
					$title = "Powerup";
				} elsif ($code == 4) {
					$title = "Cash";
				} else {
					$title = "Unknown Treasure";
				}
				
				$js .= qq{CCC_$pid.addItem("$title", "/AGC?IGC=$corename&P=TreasureSet&ID=$pid&ID2=$value");};
			}
			
			last;
		}
	}

	$js .= qq{TreasureSet.makeLastSubmenu(CCC_$pid);};	

	return $js;

}

sub ResearchJSNodes {
	my ($rid, $name) = (@_);
	my $js = '';
	my %Research = %{$IGC{Research}};
	
	foreach my $reskey (keys %Research) {
		next if $reskey =~ /Default/i;
		if ($Research{$reskey}{uid} == $rid) {
			my $rootid = $Research{$reskey}{root_tree};
			my $rootname = $root_tree[$rootid];
			if ($rootid == 0) {
				$conjs .= qq{$rootname.addItem("$name", "/AGC?IGC=$corename&P=Research&ID=$rid");};
			} elsif ($rootid == 1) {
				$garjs .= qq{$rootname.addItem("$name", "/AGC?IGC=$corename&P=Research&ID=$rid");};
			} elsif ($rootid == 2) {
				$supjs .= qq{$rootname.addItem("$name", "/AGC?IGC=$corename&P=Research&ID=$rid");};
			} elsif ($rootid == 3) {
				$tacjs .= qq{$rootname.addItem("$name", "/AGC?IGC=$corename&P=Research&ID=$rid");};
			} elsif ($rootid == 4) {
				$expjs .= qq{$rootname.addItem("$name", "/AGC?IGC=$corename&P=Research&ID=$rid");};
			} elsif ($rootid == 5) {
				$syjs .= qq{$rootname.addItem("$name", "/AGC?IGC=$corename&P=Research&ID=$rid");};
			} else {
				$uknjs .= qq{Research.addItem("$name", "/AGC?IGC=$corename&P=Research&ID=$rid");};
			}	
			last;
		}
	}

}

sub ResearchRootTree {
	return qq{$uknjs
	Research.addItem("Construction");
	var Construction = null;
	Construction = new MTMenu();
	$conjs
	Research.makeLastSubmenu(Construction);
	Research.addItem("Garrison");
	var Garrison = null;
	Garrison = new MTMenu();
	$garjs
	Research.makeLastSubmenu(Garrison);
	Research.addItem("Supremecy");
	var Supremecy = null;
	Supremecy = new MTMenu();
	$supjs
	Research.makeLastSubmenu(Supremecy);
	Research.addItem("Tactical");
	var Tactical = null;
	Tactical = new MTMenu();
	$tacjs
	Research.makeLastSubmenu(Tactical);
	Research.addItem("Shipyard");
	var Shipyard = null;
	Shipyard = new MTMenu();
	$syjs
	Research.makeLastSubmenu(Shipyard);};
}

1;