package AGC::Core::Browser;

use strict;
use vars qw(@ALL_TESTS);
require Exporter;

# Operating Systems
push @ALL_TESTS,(qw(win16 win3x win31 win95 win98 winnt windows win32 win2k winme mac mac68k macppc os2 unix sun sun4 sun5 suni86 irix irix5 irix6 hpux hpux9 hpux10 aix aix1 aix2 aix3 aix4 linux sco unixware mpras reliant dec sinix freebsd bsd vms x11 amiga));

# Devices
push @ALL_TESTS,(qw(palm audrey iopener wap));

# Browsers
push @ALL_TESTS,(qw(mosaic netscape nav2 nav3 nav4 nav4up nav45 nav45up nav6 nav6up navgold ie ie3 ie4 ie4up ie5 ie5up ie55 ie55up opera opera3 opera4 opera5 lynx aol aol3 aol4 aol5 aol6 neoplanet neoplanet2 avantgo emacs gecko));

# Robots
push @ALL_TESTS,(qw(wget getright robot yahoo altavista lycos infoseek lwp webcrawler linkexchange slurp webtv staroffice lotusnotes konqueror icab google java));

#######################################################################################################
# BROWSER OBJECT

my $default = undef;

sub new {
   my ($class, $user_agent) = @_;
   
   my $self = {};
   bless $self, $class;

   unless (defined $user_agent) {
     $user_agent = $ENV{'HTTP_USER_AGENT'};
   }

   $self->user_agent($user_agent);
   return $self;
}

foreach my $test (@ALL_TESTS) {
    no strict 'refs';
    my $key = uc $test;
    *{$test} = sub { my ($self) = _self_or_default(@_);
		     return $self->{tests}->{$key} };
}

sub _self_or_default {
   my ($self) = $_[0];
   return @_ if (defined $self &&
		 ref $self &&
		 (ref $self eq 'AGC::Core::Browser') || UNIVERSAL::isa($self,'AGC::Core::Browser'));
   $default ||= AGC::Core::Browser->new();
   unshift (@_, $default);
   return @_;
}


sub user_agent {
  my ($self, $user_agent) = _self_or_default(@_);
  if (defined $user_agent) {
    $self->{user_agent} = $user_agent;
    $self->_test();
  }
  return $self->{user_agent};
}

# Private method -- test the UA string
sub _test {
  my ($self) = @_;

  my $ua = lc $self->{user_agent};

  # Browser version
  my ($major, $minor, $beta) = ($ua =~ / \/			# Version starts with a slash
				          [A-Za-z]*		# Eat any letters before the major version
                                          ( [^\.]* )		# Major version number is everything before the first dot
                                          \.			# The first dot
                                          ( [\d]* )		# Minor version number is every digit after the first dot
                                          [\d\.]*		# Throw away remaining numbers and dots
                                          ( [^\s]* )		# Beta version string is up to next space
                                        /x);

  if (index($ua,"compatible") !=-1) {
      ($major, $minor, $beta)    = ($ua =~ / 
				    compatible;       
				    \s*
				    \w*				# Browser name
				    [\s|\/]
				    [A-Za-z]*			# Eat any letters before the major version
				    ( [^\.]* )			# Major version number is everything before first dot
				    \.				# The first dot
				    ( [\d]* )			# Minor version nnumber is digits after first dot
				    [\d\.]*			# Throw away remaining dots and digits
				    ( [^;]* )			# Beta version is up to the ;
				    ;
				    /x);


  }

  $minor = 0+".$minor"; 

  $self->{tests} = {};
  my $tests = $self->{tests};

  # Netscape browsers
  
  $tests->{NETSCAPE}  = (index($ua,"mozilla") != -1 && 
			 index($ua,"spoofer") == -1 && index($ua,"compatible") == -1 &&
			 index($ua,"opera") == -1 && index($ua,"webtv") == -1 && 
			 index($ua,"hotjava") == -1);
  $tests->{NAV2}      = ($tests->{NETSCAPE} && $major == 2);
  $tests->{NAV3}      = ($tests->{NETSCAPE} && $major == 3);
  $tests->{NAV4}      = ($tests->{NETSCAPE} && $major == 4);
  $tests->{NAV4UP}    = ($tests->{NETSCAPE} && $major >= 4); 
  $tests->{NAV45}     = ($tests->{NETSCAPE} && $major == 4 && $minor == .5);
  $tests->{NAV45UP}   = ($tests->{NAV4} && $minor >= .5) || ($tests->{NETSCAPE} && $major >= 5);
  $tests->{NAVGOLD}   = (index($beta,"gold") != -1);
  $tests->{NAV6}      = ($tests->{NETSCAPE} && $major == 5); # go figure
  $tests->{NAV6UP}    = ($tests->{NETSCAPE} && $major >= 5);
  $tests->{GECKO}     = (index($ua,"gecko") != -1);
  
  # Internet Explorer browsers

  $tests->{IE}               = (index($ua,"msie") != -1 || index($ua,'microsoft internet explorer') != -1);  
  $tests->{IE3}              = ($tests->{IE} && $major == 3);
  $tests->{IE4}              = ($tests->{IE} && $major == 4);
  $tests->{IE4UP}            = ($tests->{IE} && $major >= 4);
  $tests->{IE5}              = ($tests->{IE} && $major == 5);
  $tests->{IE5UP}            = ($tests->{IE} && $major >= 5);
  $tests->{IE55}             = ($tests->{IE} && $major == 5 && $minor >= .5);
  $tests->{IE55UP}           = ($tests->{IE5} && $minor >= .5) || ($tests->{IE} && $major >= 6);
 
  # Neoplanet browsers

  $tests->{NEOPLANET}      = (index($ua,"neoplanet") != -1);
  $tests->{NEOPLANET2}     = ($tests->{NEOPLANET} && index($ua,"2.") != -1); 

  # AOL Browsers

  $tests->{AOL}       = (index($ua,"aol")     != -1);
  $tests->{AOL3}      = (index($ua,"aol 3.0") != -1) || ($tests->{AOL} && $tests->{IE3});
  $tests->{AOL4}      = (index($ua,"aol 4.0") != -1) || ($tests->{AOL} && $tests->{IE4});
  $tests->{AOL5}      = (index($ua,"aol 5.0") != -1);
  $tests->{AOL6}      = (index($ua,"aol 6.0") != -1);
  $tests->{AOLTV}     = (index($ua,"navio") != -1) || (index($ua,"navio_aoltv") != -1);

  # Opera browsers
  
  $tests->{OPERA}     = (index($ua,"opera")   != -1);
  $tests->{OPERA3}    = (index($ua,"opera 3") != -1) || (index($ua,"opera/3") != -1);
  $tests->{OPERA4}    = (index($ua,"opera 4") != -1) || (index($ua,"opera/4") != -1);
  $tests->{OPERA5}    = (index($ua,"opera 5") != -1) || (index($ua,"opera/5") != -1);
  
  # Other browsers

  $tests->{STAROFFICE}     = (index($ua,"staroffice") != -1);
  $tests->{ICAB}           = (index($ua,"icab") != -1);
  $tests->{LOTUSNOTES}     = (index($ua,"lotus-notes") != -1);
  $tests->{KONQUEROR}      = (index($ua,"konqueror") != -1);
  $tests->{LYNX}           = (index($ua,"lynx") != -1);
  $tests->{WEBTV}          = (index($ua,"webtv") != -1);
  $tests->{MOSAIC}         = (index($ua,"mosaic") != -1);
  $tests->{WGET}           = (index($ua,"wget") != -1);
  $tests->{GETRIGHT}       = (index($ua,"getright") != -1);
  $tests->{LWP}            = (index($ua,"libwww-perl") != -1 ||
			      index($ua,"lwp-") != -1);
  $tests->{YAHOO}          = (index($ua,"yahoo") != -1);
  $tests->{GOOGLE}         = (index($ua,"google") != -1);
  $tests->{JAVA}           = (index($ua,"java") != -1 ||
			      index($ua,"jdk") != -1);
  $tests->{ALTAVISTA}      = (index($ua,"altavista") != -1);
  $tests->{SCOOTER}        = (index($ua,"scooter") != -1);
  $tests->{LYCOS}          = (index($ua,"lycos") != -1);
  $tests->{INFOSEEK}       = (index($ua,"infoseek") != -1);
  $tests->{WEBCRAWLER}     = (index($ua,"webcrawler") != -1); 
  $tests->{LINKEXCHANGE}   = (index($ua,"lecodechecker") != -1); 
  $tests->{SLURP}          = (index($ua,"slurp") != -1);
  $tests->{ROBOT}          = (($tests->{WGET} ||
			       $tests->{GETRIGHT} ||
			       $tests->{LWP} ||
			       $tests->{YAHOO} ||
			       $tests->{ALTAVISTA} ||
			       $tests->{LYCOS} ||
			       $tests->{INFOSEEK} ||
			       $tests->{WEBCRAWLER} ||
			       $tests->{LINKEXCHANGE} ||
			       $tests->{SLURP} ||
			       $tests->{GOOGLE}) ||
			      index($ua,"bot") != -1 ||
			      index($ua,"spider") != -1 ||
			      index($ua,"crawl") != -1 ||
			      index($ua,"agent") != -1 ||
			      index($ua,"seek") != -1 ||
			      index($ua,"search") != -1 ||
			      index($ua,"reap") != -1 ||
			      index($ua,"worm") != -1 ||
			      index($ua,"find") != -1 ||
			      index($ua,"index") != -1 ||
			      index($ua,"copy") != -1 ||
			      index($ua,"fetch") != -1);

  # Devices

  $tests->{AUDREY}        = (index($ua,"audrey") != -1);
  $tests->{IOPENER}       = (index($ua,"i-opener") != -1);
  $tests->{AVANTGO}        = (index($ua,"avantgo") != -1);
  $tests->{PALM}          = ($tests->{AVANTGO} || 
			     index($ua,"palmos") != -1 );
  $tests->{WAP}           = (index($ua,"up.browser") != -1 ||
			     index($ua,"nokia") != -1 ||
			     index($ua,"alcatel") != -1 ||
			     index($ua,"ericsson") != -1 ||
			     index($ua,"sie-") == 0 ||
			     index($ua,"wmlib") != -1 ||
			     index($ua," wap") != -1 ||
			     index($ua,"wap ") != -1 ||
			     index($ua,"wap/") != -1 ||
			     index($ua,"-wap") != -1 ||
			     index($ua,"wap-") != -1 ||
			     index($ua,"wap") == 0 ||
			     index($ua,"wapper") != -1 ||
			     index($ua,"zetor") != -1);
			     
			     
  # Operating System
  
  $tests->{WIN16}    = (index($ua,"win16") != -1 || index($ua,"16bit") != -1 || index($ua,"windows 3") != -1 ||
			index($ua,"windows 16-bit") != -1);
  $tests->{WIN3X}    = (index($ua,"win16") != -1 || index($ua,"windows 3") != -1 || index($ua,"windows 16-bit") != -1);
  $tests->{WIN31}    = (index($ua,"win16") != -1 || index($ua,"windows 3.1") != -1 || index($ua,"windows 16-bit") != -1);
  $tests->{WIN95}    = (index($ua,"win95") != -1 || index($ua,"windows 95") != -1);
  $tests->{WIN98}    = (index($ua,"win98") != -1 || index($ua,"windows 98") != -1);
  $tests->{WINNT}    = (index($ua,"winnt") != -1 || 
			index($ua,"windows nt") != -1 || 
			index($ua,"nt4") != -1 || 
			index($ua,"nt3") != -1);
  $tests->{WIN2K}    = (index($ua,"nt 5") != -1 || index($ua,"nt5") != -1);
  $tests->{WINME}    = (index($ua,"win 9x 4.90") != -1); # whatever
  $tests->{WIN32}    = (($tests->{WIN95} || $tests->{WIN98} || $tests->{WINME} || $tests->{WINNT} || 
			 $tests->{WIN2K}) || index($ua,"win32") != -1);
  $tests->{WINDOWS}  = (($tests->{WIN16} || $tests->{WIN31} || $tests->{WIN95} || $tests->{WIN98} ||
			 $tests->{WINNT} || $tests->{WIN32} || $tests->{WIN2K} || $tests->{WINME}) || index($ua,"win") != -1);
  
  # Mac operating systems
  
  $tests->{MAC}      = (index($ua,"macintosh") != -1 || index($ua,"mac_") != -1);
  $tests->{MAC68K}   = (($tests->{MAC}) && (index($ua,"68k") != -1 || index($ua,"68000") != -1));
  $tests->{MACPPC}   = (($tests->{MAC}) && (index($ua,"ppc") != -1 || index($ua,"powerpc") != -1));
  
  # Others
  
  $tests->{AMIGA}   = (index($ua,'amiga') != -1);
  $tests->{EMACS}   = (index($ua,'emacs') != -1);
  $tests->{OS2}     = (index($ua,'os/2') != -1);
  
  $tests->{SUN}     = (index($ua,"sun") != -1);
  $tests->{SUN4}    = (index($ua,"sunos 4") != -1);
  $tests->{SUN5}    = (index($ua,"sunos 5") != -1);
  $tests->{SUNI86}  = (($tests->{SUN}) && index($ua,"i86") != -1);
  
  $tests->{IRIX}    = (index($ua,"irix") != -1);
  $tests->{IRIX5}   = (index($ua,"irix5") != -1);
  $tests->{IRIX6}   = (index($ua,"irix6") != -1);
  
  $tests->{HPUX}    = (index($ua,"hp-ux") != -1);
  $tests->{HPUX9}   = (($tests->{HPUX}) && index($ua,"09.") != -1);
  $tests->{HPUX10}  = (($tests->{HPUX}) && index($ua,"10.") != -1);
  
  $tests->{AIX}   = (index($ua,"aix") != -1);
  $tests->{AIX1}  = (index($ua,"aix 1") != -1);
  $tests->{AIX2}  = (index($ua,"aix 2") != -1);
  $tests->{AIX3}  = (index($ua,"aix 3") != -1);
  $tests->{AIX4}  = (index($ua,"aix 4") != -1);
  
  $tests->{LINUX}     = (index($ua,"inux") != -1);
  $tests->{SCO}       = (index($ua,"sco") != -1 || index($ua,"unix_sv") != -1);
  $tests->{UNIXWARE}  = (index($ua,"unix_system_v") != -1);
  $tests->{MPRAS}     = (index($ua,"ncr") != -1);
  $tests->{RELIANT}   = (index($ua,"reliantunix") != -1);
  
  $tests->{DEC} = (index($ua,"dec") != -1 || index($ua,"osf1") != -1 || index($ua,"declpha") != -1 || 
		   index($ua,"alphaserver") != -1 || index($ua,"ultrix") != -1 ||
		   index($ua,"alphastation") != -1);
  
  $tests->{SINIX}    = (index($ua,"sinix") != -1);
  $tests->{FREEBSD}  = (index($ua,"freebsd") != -1);
  $tests->{BSD}      = (index($ua,"bsd") != -1);
  $tests->{X11}      = (index($ua,"x11") != -1);
  $tests->{UNIX}     = ($tests->{X11} || $tests->{SUN} || $tests->{IRIX} || $tests->{HPUX} ||
			$tests->{SCO} || $tests->{UNIXWARE} || $tests->{MPRAS} ||
			$tests->{RELIANT} || $tests->{DEC} || $tests->{LINUX} ||
			$tests->{BSD}); 

  $tests->{VMS} = (index($ua,"vax") != -1 || index($ua,"openvms") != -1);

  $self->{major} = $major;
  $self->{minor} = $minor;
  $self->{beta} = $beta;
}
    
sub browser_string {
    my ($self) = _self_or_default(@_);
    my $browser_string = undef;
    my $user_agent = $self->user_agent;
    if (defined $user_agent) {
        $browser_string = 'Netscape' if $self->netscape;
        $browser_string = 'MSIE' if $self->ie;  
        $browser_string = 'WebTV' if $self->webtv;
        $browser_string = 'AOL Browser' if $self->aol;
        $browser_string = 'Opera' if $self->opera;
        $browser_string = 'Mosaic' if $self->mosaic;
        $browser_string = 'Lynx' if $self->lynx;
    }
    return $browser_string;
}
    
sub os_string {
    my ($self) = _self_or_default(@_);
    my $os_string = undef;
    my $user_agent = $self->user_agent;
    if (defined $user_agent) {
        $os_string = 'Win95' if $self->win95;
        $os_string = 'Win98' if $self->win98;
        $os_string = 'WinNT' if $self->winnt;
        $os_string = 'Mac' if $self->mac;
        $os_string = 'Win3x' if $self->win3x;
        $os_string = 'OS2' if $self->os2;
        $os_string = 'Unix' if $self->unix && !$self->linux;
        $os_string = 'Linux' if $self->linux;
    }
    return $os_string;
}
    
sub version {
  my ($self, $check) = _self_or_default(@_);
  my $version;
  $version = $self->{major} + $self->{minor};
  if (defined $check) { 
    return $check == $version;
  } else {
    return $version;
  }
}
    
sub major {
  my ($self, $check) = _self_or_default(@_);
  my ($version) = $self->{major};
  if (defined $check) { 
    return $check == $version;
  } else {
    return $version;
  }
}
    
sub minor {
  my ($self, $check) = _self_or_default(@_);
  my ($version) = $self->{minor};
  if (defined $check) { 
      return ($check == $self->{minor});
  } else {
    return $version;
  }
}
    
sub beta {
  my ($self, $check) = _self_or_default(@_);
  my ($version) = $self->{beta};
  if ($check) { 
    return $check eq $version;
  } else {
    return $version;
  }
}

1;
    

__END__
