package AGC::Core::Cookie;

use strict;
use CGI::Cookie;
use Crypt::CBC;
use Crypt::Rijndael;

#use Apache::Log;
#use Data::Dumper;

# setup our cipher (/w 32B key)
use vars qw($AES);
$AES = Crypt::CBC->new('ovinmusicistheanswertotheproblem','Crypt::Rijndael');

# The following global variable is required somewhere in our code base
# to make mod perl load with it enabled.  It is actually required in
# our Crypt objects for the cryptography to work in the c based libraries
# but will not load enless used somewhere in the perl code base.
{
	$';
}

sub new {
	my $pkg = shift;

	# The following uses the CGI::Cookie operator fetch to return
	# all cookies in an associative array where the keys are the
	# cookie names.
	#
	# Each cookie object in the array contains the following
	# accessor/mutator's:
	#
	# name    - get or set the cookie's name
	# value   - get or set the cookie's value *(only one used)*
	# domain  - get or set the cookie's domain
	# path    - get or set the cookie's path
	# expires - get or set the cookie expiration time
	#
	# Note:  To save us future grief, we will not use these objects
	#        to set the cookie information, but will create new
	#        ones whenever we desire a set a cookie.
	#
	# Also, even though the cookie spec's state that the above
	# information other than value is supposed to be sent in the
	# request header, our headers fail to contain anything but the
	# name and value.

	my %this = fetch CGI::Cookie;
	
	bless \%this, $pkg;
}

sub get {
	# If cookie $name exists, decryptes and splits the values into
	# a hash reference that is returned.  Otherwise returns undef.

	my ($this, $name) = @_;
	#Apache->request->log->error("We are in Cookie::get ($name) 1");
	
	# Return undefined if cookie $name does not exist
	return undef unless $this->value($name);
	#Apache->request->log->error("We are in Cookie::get ($name) 2");
	my $decrypted_cookie;

	$decrypted_cookie = &DecryptData($this->value($name));
	#Apache->request->log->error("Pre: ".Dumper($decrypted_cookie));
	
	# The Delimeter ## is used to separate key value pairs
	# The Delimeter :: is used to separate keys and values

	my %hash = split('##|::', $decrypted_cookie);
	#Apache->request->log->error("Mid: ".Dumper(\%hash));
	$hash{$_} =~ s/-(#|:)-/$1/g foreach keys %hash;
	#Apache->request->log->error("Post: ".Dumper(\%hash));
	return \%hash;
}

sub value {
	# Gets the Value of a Cookie, if exists only
	my ($this, $name) = @_;
	
	return (defined $this->{$name}) ? $this->{$name}->value : undef;
}		

sub path {
	# Gets the Path of a Cookie, if exists only
	my ($this, $name) = @_;
	
	return (defined $this->{$name}) ? $this->{$name}->path : undef;
}	

sub set {
	# ->set($name, $domain, $hashref, $expire_date, $CID);
	# ->set($name, $domain);
	#
	# Creates a cookie, encryptes it, and sets it.  If I<$hash_ref> is passed,
	# populates the object with the passed hash, then sets the cookie named
	# $name.  If not passed I<$hash_ref> then the cookie is nulled.

	my $this = shift;

	my ($name, $domain, $hashref, $expire_date) = @_;

	my ($encrypted_string, $path) = ('', '');

	if (ref($hashref) eq 'HASH') {
		# If passed a hash - set cookie
		${$hashref}{$_} =~ s/(#|:)/-$1-/g foreach (keys %$hashref);
	
		$encrypted_string = &EncryptData( join('##', map($_ .'::' . ${$hashref}{$_}, keys %$hashref)) . '##'); #removed ## from front
		
	} else {
		# Expire cookie if no hash passed
		delete $this->{$name} if exists $this->{$name};
		$expire_date = '-1d';
	}


	# set cookie
	my $cookie = new CGI::Cookie(
		-name    => $name,
		-value   => $encrypted_string,
	    #-domain  => $domain,
		-path    => '/',
		#-expires => $expire_date
	);

	my $setcookie = $cookie->as_string();
	return $setcookie;
}

##
# Input: Encrypted data
# Output: Plain data
sub DecryptData {return $AES->decrypt(shift);}
#sub DecryptData {return shift;} #debug

##
# Input: Plain data
# Output: Encrypted data
sub EncryptData {return $AES->encrypt(shift);}
#sub EncryptData {return shift;} #debug


1;