package AGC::Core::File;

require	Exporter;
@ISA = qw(Exporter);
@EXPORT_OK = qw(&write &move);

use strict;
use Fcntl;
use Errno qw(EINTR);


# lock safe file writing
# input 	: file handle, path
# output	: bytes written
sub write {
	my ($data, $localpath) = @_;
	
	sysopen(FH, $localpath, O_WRONLY|O_CREAT|O_TRUNC, 0664) or die "sysopen error in Write() reason: $!";
	flock FH, 2;
	my $bytes = &fd_to_fd( $data, *FH );
	flock FH, 8;
	close FH;
	return $bytes;
}

# lock safe file moving
# input 	: from path, to path
# output	: 1 it worked, 0 it didnt work
sub move {
	my ($from, $to, $shit) = @_;

	sysopen(FROM_FH, $from, O_RDONLY|O_CREAT|O_NONBLOCK, 0664 ) or die "sysopen error in Move() reason: $!";
	sysopen(TO_FH, $to, O_WRONLY|O_CREAT|O_TRUNC, 0664 ) or die "sysopen error in Move() reason: $!";
	flock TO_FH, 2;
	my $bytes = &fd_to_fd( *FROM_FH, *TO_FH );
	flock TO_FH, 8;
	close FROM_FH;
	close TO_FH;
	my $return = unlink $from if ($bytes && !$shit);
	return $return;
}

# copies one file descriptor to another (insanly) with a 4k buffer
sub fd_to_fd {

	my ( $from_fd, $to_fd ) = @_;
	my ( $rin, $rtemp, $wout, $wtemp, $buffer, $totalsize );

	vec($rin,  fileno( $from_fd ), 1) = 1;
	vec($wout, fileno( $to_fd   ), 1) = 1;

	while ( select($rtemp = $rin, undef, undef, 120) ) {
		my $buffer_size = sysread $from_fd, $buffer, 4096;
		unless ( defined $buffer_size ) {
			next if $! == EINTR;
			die "Read Failed: $!";
		}
		last unless $buffer_size;
		my $offset = 0;
		while ( $buffer_size ) {
			select( undef, $wtemp = $wout, undef, 120 ) or last;
			my $written = syswrite $to_fd, $buffer, $buffer_size, $offset;
			unless ( defined $written ) {
				next if $! == EINTR;
				die "Write Failed: $!";
			}
			$buffer_size	-= $written;
			$offset			+= $written;
			$totalsize		+= $written;
		}
	}
	return $totalsize;
}

1;
__END__