package	AGC::Core::Form;

require	Exporter;
@ISA = qw(Exporter);
@EXPORT	= ();
@EXPORT_OK = qw(MakeCoreSelectForm MakeCoreUploadForm MakeCheckboxesArray MakeOptionsArray MakeRadioArray);


use strict;

sub MakeCoreSelectForm {
	my $html;
	my $some_dir = ($ENV{GATEWAY_INTERFACE}) ? $ENV{TEMP_PATH} : 'Temp';
	opendir(DIR, $some_dir) || die "can't opendir $some_dir: $!";
	my @corefiles = grep { /\.igc$/ && -f "${some_dir}$_" } readdir(DIR);
    closedir DIR;
	my $opts = &MakeOptionsArray(\@corefiles,\@corefiles,'plus11');
	
	my $html = qq{
	<script>
	var textdisplay=new Array()
	textdisplay[0]="<b>Author:<b> <pre>unkown</pre> &nbsp; <b>Last Modified:</b> <pre>blaha sdasdasd</pre> &nbsp; <b>Size:</b> <pre>420KB</pre>"
	</script>
	<form name="ViewSelect" action="/AGC" method="POST" onSubmit="submitonce(this)">
	<select name="IGC" onChange="displaydesc(document.ViewSelect.IGC.selectedIndex)">
	$opts
	</select>
	
	<input type="button" value="Go" onClick="jumptolink(document.ViewSelect.IGC.selectedIndex)"><br>
	<span id="descriptions" align="left" style="font:italic 13px Arial">
	</span>
	</form>
	<script>
	var textdisplay=new Array()
	textdisplay[0]="A sample core..."
	textdisplay[1]="This must be your core..."
	function jumptolink(what){
	var selectedopt=document.ViewSelect.IGC.options[what]
	if (document.getElementById && selectedopt.getAttribute("target")=="newwin")
	window.open("/AGC/?IGC="+selectedopt.value+"&P=View")
	else
	window.location="/AGC/?IGC="+selectedopt.value+"&P=View"
	}

	function displaydesc(which){
	if (document.all)
	descriptions.innerHTML=textdisplay[which]
	else if (document.getElementById)
	document.getElementById("descriptions").innerHTML=textdisplay[which]
	}

	displaydesc(document.ViewSelect.IGC.selectedIndex)

	document.ViewSelect.IGC.options[0].selected=true
	</script>};
	
	return $html;

}

sub MakeCoreUploadForm {
	my $html = qq{<form name="UploadForm" action="/AGCUpload" method="POST" enctype="multipart/form-data" onSubmit="submitonce(this)">
	<input type="file" name="filename"><input type=submit value="Go">
	</form>
	};
	return $html;
}

sub MakeCheckboxesArray {
	# Takes four parameters (names, values, texts, and optional checked values)
	# and generates a group of checkboxes.  Parameters may be scalars or arrays.
	# Default checkbox values to "ON" by passing a values array like (ON,ON,ON...)--
	#   but note this is different from from being "checked"!
	# Checked values evaluated against texts parameter.
	# See main comments for information on delimiter parameters.
	my ($optnames,$optvals,$opttext,$optchecked,$predelimiter1,$postdelimiter1,$predelimiter2,$postdelimiter2) = @_;
	my @names = ref($optnames) ? @$optnames : ($optnames);
	my @vals = ref($optvals) ? @$optvals : ($optvals);
	my @text = ref($opttext) ? @$opttext : ($opttext);
	my @checked = ref($optchecked) ? @$optchecked : ($optchecked);
	($predelimiter1 && !$predelimiter2) && ($predelimiter2 = $predelimiter1);
	($postdelimiter1 && !$postdelimiter2) && ($postdelimiter2 = $postdelimiter1);
	my ($checkboxes,$checkedval,$checkedtext);
	for (my $i = 0; $i < @vals; $i++) {
		$checkedtext = '';
		foreach $checkedval (@checked) {
			$checkedtext = ' CHECKED' if $text[$i] eq $checkedval;
		}
		$checkboxes .= ($i % 2) ? ("$predelimiter2<INPUT TYPE='CHECKBOX' NAME='$names[$i]' VALUE='$vals[$i]'$checkedtext>$text[$i]$postdelimiter2\n") :
								  ("$predelimiter1<INPUT TYPE='CHECKBOX' NAME='$names[$i]' VALUE='$vals[$i]'$checkedtext>$text[$i]$postdelimiter1\n");
	}
	return $checkboxes;
}


sub MakeOptionsArray {
	# Takes three parameters (values, texts, and optional selected values)
	# and generates options for a <SELECT> box.  Compatible with MULTIPLE.
	# Parameters may be scalars or arrays.
	# Selected value(s) evaluated against the array of values.
	my ($optvals,$opttext,$optselected) = @_;
	my @vals = ref($optvals) ? @$optvals : ($optvals);
	my @text = ref($opttext) ? @$opttext : ($opttext);
	my @selected = ref($optselected) ? @$optselected : ($optselected);
	my ($options,$selectedval,$selectedtext);
	for (my $i = 0; $i < @vals; $i++) {
		$selectedtext = '';
		foreach $selectedval (@selected) {
			$selectedtext = ' SELECTED' if $vals[$i] eq $selectedval;
		}
		$options .= "\n<OPTION VALUE='$vals[$i]'$selectedtext>$text[$i]";
	}
	return $options;
}

sub MakeRadioArray {
	# Takes the radio button group name, three parameters (values,
	# texts, and optional checked value) and generates a group of
	# radio buttons.  Values and texts may be scalars or arrays.
	# Checked value(s) evaluated against the values parameter.
	# See main comments for information on delimiter parameters.
	my ($name,$optvals,$opttext,$checkedval,$predelimiter1,$postdelimiter1,$predelimiter2,$postdelimiter2) = @_;
	my @vals = ref($optvals) ? @$optvals : ($optvals);
	my @text = ref($opttext) ? @$opttext : ($opttext);
	($predelimiter1 && !$predelimiter2) && ($predelimiter2 = $predelimiter1);
	($postdelimiter1 && !$postdelimiter2) && ($postdelimiter2 = $postdelimiter1);
	my ($radio,$checkedtext);
	for (my $i = 0; $i < @vals; $i++) {
		$checkedtext = $vals[$i] eq $checkedval ? ' CHECKED' : '';
		$radio .= ($i % 2) ? ("$predelimiter2<INPUT TYPE='RADIO' NAME='$name' VALUE='$vals[$i]'$checkedtext>$text[$i]$postdelimiter2\n") :
							 ("$predelimiter1<INPUT TYPE='RADIO' NAME='$name' VALUE='$vals[$i]'$checkedtext>$text[$i]$postdelimiter1\n");
	}
	return $radio;
}

1;

__END__