package AGC::Core::Session;

use strict;
use AGC::Core::Cookie;

use vars qw($domainver_re $hostprefix_re $fdat);

use constant {
	VERSION 		=> 'AGCv1',
	EXPIRE			=> 'Friday, 31-Dec-2010 23:59:59 GMT',
};

$domainver_re = qr{^D};
$hostprefix_re = qr{^[^\.]+};

sub _domain {
	my $ver = scalar(@_) ? shift : VERSION;
	my $host = (split(':', $ENV{HTTP_HOST}))[0];

	(my $domain = $host) =~ s/$hostprefix_re//;

	if ($ver =~ m/$domainver_re/) {
		return $domain;
	} else {
		return ($host, $domain);
	}
}

sub new {
	my $pkg = shift;
	my $this = {COOKIE => new AGC::Core::Cookie, COOKIENAME => defcn()};

	bless $this, $pkg;
	
	return $this;
}


sub get {
	my ($this, $cookiename) = @_;
	
	$cookiename ||= $this->cookiename;
	
	return undef if (! (defined($this->cookie)) );
	
	if (my $cookie = $this->cookie->get($cookiename)) {
		if ($cookie->{VER} ne VERSION) {
			$this->clear($cookiename);
		} else {
			$this->{$_} = $cookie->{$_} foreach qw(SID UA IP VER LOGIN ISADMIN TIME);
			$this->cookiename($cookiename);
		}
	}
	
	return $this->sid ? 1 : undef;
}

sub sid				{ return shift->{SID} || undef }
sub ua				{ return shift->{UA} }
sub ip				{ return shift->{IP} }
sub login			{ return shift->{LOGIN} }
sub cookie			{ return shift->{COOKIE} }
sub isadmin			{ return shift->{ISADMIN} }
sub defcn			{ return 'AGC' }

sub cookiename {
	my $this = shift;
	$this->{COOKIENAME} = $_[0] if (@_);
	return $this->{COOKIENAME};
}

sub set {
	my $this = shift;
	my $host = &_domain();
	my (%hash);

	$hash{VER} 	= VERSION;
	$hash{TIME}	= time();
	$hash{SID} 	= _my_gen_id();
	$hash{IP} 	= $ENV{REMOTE_ADDR};
	$hash{UA}	= $ENV{HTTP_USER_AGENT};
	if ($hash{IP} eq '127.0.0.1' || $hash{IP} eq 'localhost') {$hash{ISADMIN}=1;}
	
	@{$this}{qw(VER TIME SID UA IP ISADMIN LOGIN)} = @hash{qw(VER TIME SID UA IP ISADMIN LOGIN)};

	my $setcookie = $this->cookie->set($this->cookiename, $host, \%hash, EXPIRE);
	
	return $setcookie;
}

sub _my_gen_id {
    srand($$|time);
    my $session = int(rand(600000000000));
    return unpack("H*", pack("Nnn", time, $$, $session));
}   

1;

__END__