package AGC::Handlers::HTML;

use strict;   
use AGC::Init;
use AGC::Pages::Index;
use AGC::Pages::Tree;
use AGC::Pages::Globals;

sub handler {
	my $r = shift;
	
	AGC::Init::Core;
	my %vars = $fdat->Vars;

	my $page = $vars{P} || 'Index';
	my $html = ($P{$page}) ? $P{$page}->() : $P{Error}->();	

	if ( $ENV{AGC_REDIRECT} ) {
      	$r->err_headers_out->add('Set-Cookie' => $setcookie) if ($setcookie);
      	$r->headers_out->set(Location => $ENV{AGC_REDIRECT});

		return Apache::REDIRECT;
	}
	$r->err_headers_out->add('Set-Cookie' => $setcookie) if ($setcookie);
	$r->content_type('text/html');
	$r->headers_out->set('Content-Length' => length($html));
	if ($ENV{AGC_NOCACHE}) {
		$r->headers_out->set('Pragma' => "no-cache");
  		$r->headers_out->set('Cache-control' => "no-cache");
  		$r->headers_out->add('Cache-control' => "no-store");
  	}
  	
	$r->puts($html);

	return Apache::OK
}

1;

__END__




















