package AGC::Init;

require	Exporter;
@ISA = qw(Exporter);
@EXPORT = qw($fdat $sdat $hosturi $setcookie %IGC $corename Core Pages %P $DUMP $browser);

use strict;
use CGI qw(-compile :all);
use XML::Dumper;
use AGC::Core::Browser;
use AGC::Core::Session;

use vars qw($fdat $sdat $hosturi %IGC %P $setcookie $corename $DUMP $browser);

sub handler {
	if (!$IGC{CORENAME}) {
		my $rootpath = ($ENV{GATEWAY_INTERFACE}) ? $ENV{TEMP_PATH} : undef;
		my $xmlpath = $rootpath.$ENV{CACHED_CORE}.'.xml.gz';
		$DUMP ||= new XML::Dumper;
		my $perl = $DUMP->xml2pl($xmlpath);
		%IGC = %{$perl};
	}
}

sub Core {
	$fdat = CGI->new;
	my %vars = $fdat->Vars;
	$DUMP ||= new XML::Dumper;
	$browser ||= new AGC::Core::Browser($fdat->user_agent);
	$hosturi = $ENV{HTTPS} eq 'on' ? 'https://' : 'http://';
	$hosturi .= $ENV{HTTP_HOST};
	$corename = $vars{IGC} || 'plus11';
	$corename =~ s/\.igc$//i;
	$sdat ||= new AGC::Core::Session;
	if (!$sdat->get()) {
		$setcookie = $sdat->set();
	}
	if ($IGC{CORENAME} ne $corename) {
		my $rootpath = ($ENV{GATEWAY_INTERFACE}) ? $ENV{TEMP_PATH} : undef;
		my $xmlpath = $rootpath.$corename.'.xml.gz';
		my $perl = $DUMP->xml2pl($xmlpath);
		%IGC = %{$perl};
	}
	&Pages
}

sub Pages {
	%P = (
			Index		=>	\&AGC::Pages::Index::Entry,
			View		=>	\&AGC::Pages::Index::Viewer,
			Globals		=>	\&AGC::Pages::Globals::View,
			TreeMenu	=>	\&AGC::Pages::Tree::Menu,
			TreeNodes	=>	\&AGC::Pages::Tree::Nodes,
			TreeEmpty	=>	\&AGC::Pages::Tree::Empty,
			TreeHeading =>	\&AGC::Pages::Tree::Heading,
			Error		=>	\&Error,
		 ); 
}

sub Error {return 'wtf';}

1;

__END__