package AGC::Pages::Tree;

use strict;
use AGC::Core qw(MagazineJSNodes CCCJSNodes ProjectileJSNodes ResearchJSNodes ResearchRootTree);
use AGC::Init;

sub Menu {

	my $html = qq{<html>
<head>
<title>Active Game Core</title>
</head>
<body>
<p>This is a static HTML document, and is to be used as a &quot;menu&quot; for those without JavaScript.  It should therefore reflect the menu itself and give links to useful content.</p>

</body>
</html>};
	
	return $html;

}

#"
 
sub Nodes {
	my $part_js = '';
	my %Parts = %{$IGC{Part}};
	foreach my $key (keys %Parts) {
		next if $key =~ /Default/i;
		my %Part = %{$Parts{$key}};
		$part_js .= qq{
			parts.addItem("$key");
			var $key = null;
			$key = new MTMenu();
		};
		foreach my $part (keys %Part) {
			if ($key eq 'Magazine') {
				$part_js .= MagazineJSNodes($Parts{$key}{$part}{uid},$Parts{$key}{$part}{usemask},$Parts{$key}{$part}{type});
			}
			my $value = $Parts{$key}{$part}{name};
			next if $value =~ /Default/i || $value eq '';
			$part_js .= qq{$key.addItem("$value", "/AGC?IGC=$corename&P=Part&Type=$key&ID=$part")
			};
		}
		$part_js .= qq{parts.makeLastSubmenu($key);};
	}

	my $igc_js = '';
	TYPE: foreach my $type (keys %IGC) {
		next TYPE if $type =~ /Part|Global|CORENAME/i;
		my %Types = %{$IGC{$type}};
		$igc_js .= qq{menu.addItem("$type");
			var $type = null;
			$type = new MTMenu();
		} if ($type ne 'Research');
		ITEM: foreach my $key (keys %Types) {
			my $item = $Types{$key};
			if ($type eq 'Projectile') {$igc_js .= ProjectileJSNodes($item->{uid});}
			if ($type eq 'TreasureSet') {$igc_js .= CCCJSNodes($item->{uid},$item->{name});}
			if ($type eq 'Research') {ResearchJSNodes($item->{uid},$item->{name});}
			next ITEM if (!(exists ($item->{name})) || $type eq 'TreasureSet' || $type eq 'Research');
			my $value = $item->{name};
			next if $value =~ /Default/i || $value eq '';
			$igc_js .= qq{$type.addItem("$value", "/AGC?IGC=$corename&P=$type&ID=$key");
			};
		}
		$igc_js .= qq{menu.makeLastSubmenu($type);} if ($type ne 'Research');
	}
	my $res_js = ResearchRootTree;

	my $html = qq{<html>
<head>
<title>Active Game Core</title>
<script type="text/javascript">
var relocateURL = "/AGC";
if(parent.frames.length == 0) {
  if(document.images) {
    location.replace(relocateURL);
  } else {
    location = relocateURL;
  }
}
</script>
<script type="text/javascript" src="/AGCStatic/tree.js"></script>
<script type="text/javascript">

MTMDefaultTarget = "text";

var MTMIconList = null;
MTMIconList = new IconList();

var menu = null;
menu = new MTMenu();
menu.addItem("Globals", "/AGC?IGC=$corename&P=Globals");
menu.addItem("Parts");
var parts = null;
parts = new MTMenu();
$part_js
menu.makeLastSubmenu(parts);
menu.addItem("Research");
var Research = null;
Research = new MTMenu();
$res_js
menu.makeLastSubmenu(Research);
$igc_js
</script>
</head>
<body onload="MTMStartMenu(true)" bgcolor="#000033" text="#ffffcc" link="yellow" vlink="lime" alink="red">
</body>
</html>};
	
	return $html;

}

#"

sub Empty {
	return qq{<html>
<head>
<title>[insert your title here]</title>
<style type="text/css" id="mtmsheet">
/* this is only a Mozilla quirk fix */
</style>
</head>
<body>
<!-- blank page -->
<p>This document is shown to users before it is replaced by the tree menu. A link to 'menu.html' is useful for those who do not have JavaScript enabled.  Example:</p>

<p><a href="menu.html">No JavaScript?</a></p>

</body>
</html>};
}

#"

sub Heading {
return qq{<html>
<head>
<title>Active Game Core</title>
</head>

<body>
<h1>AGC Viewer - $corename</h1>
</body>
</html>};
}


1;

__END__